<?php defined('SYSPATH') or die('No direct script access.');

class Task_Insert_Post extends Minion_Task{

    protected function _execute(array $params){
        Task_Helper::createWorker('Post:Insert', $this, 'Worker', rand(5000, 10000));
    }

    public function Worker(GearmanJob $job){
        $data = json_decode($job->workload(), true);
        $data = array_change_key_case($data, CASE_LOWER);

        $fields = ['client_id', 'link', 'datetime', 'data', 'logkeys', 'image', 'os', 'os_ver', 'group'];
        $client = DB::select('id')
            ->from('clients')
            ->where('cid0','=', $data['cid0'])
            ->where('cid1','=', $data['cid1'])
            ->limit(1)
            ->execute()
            ->as_array();

        if(empty($client)) {
            $gearman = Task_Helper::getClient();
            $gearman->setCompleteCallback(function ($task) use (&$data, &$client) {
                if ($task->data()) {
                    $client = json_decode($task->data(), true);
                }
            });
            $json = json_encode($data);
            $gearman->addTask("Insert:Client:Info", $json, null, md5($json));
            $gearman->runTasks();
        }

        if(Model_Insert_Blacklist::checkBlackList($data['link'], 0)) {

            if(!isset($client[0])){
                unset($data['data']);
                Minion_CLI::write('Client not exist! Pls see log file!');
                Minion_CLI::write(json_encode($data));
                return;
            }

            $data['client_id'] = $client[0]['id'];
            if (!is_string($data['data'])) {
                $data['data'] = json_encode($data['data']);
            }

            DB::insert('logpost', $fields)
                ->values(Arr::extract($data, $fields))
                ->execute();

            if (rand(0, 1)) {
                $gearman = Task_Helper::getClient();
                $gearman->addTaskBackground("Insert:Counter", '_', null, 'Insert:Counter');
                $gearman->runTasks();
            }
        }
    }
}